VERSION 5.00
Begin VB.Form D 
   Caption         =   "NorhofDemo3"
   ClientHeight    =   3135
   ClientLeft      =   60
   ClientTop       =   405
   ClientWidth     =   7080
   Icon            =   "Demo3.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   3135
   ScaleWidth      =   7080
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox pingbox 
      Height          =   285
      Left            =   6360
      TabIndex        =   8
      Text            =   "ms"
      Top             =   1680
      Width           =   615
   End
   Begin VB.CommandButton pingbutton 
      Caption         =   "ping"
      Height          =   375
      Left            =   5640
      TabIndex        =   7
      Top             =   1560
      Width           =   615
   End
   Begin VB.CommandButton POFbutton 
      Caption         =   "POF"
      Height          =   375
      Left            =   4200
      TabIndex        =   6
      Top             =   840
      Width           =   975
   End
   Begin VB.CommandButton PONbutton 
      Caption         =   "PON"
      Height          =   375
      Left            =   4200
      TabIndex        =   5
      Top             =   240
      Width           =   975
   End
   Begin VB.CommandButton readbutton 
      Caption         =   "read"
      Height          =   375
      Left            =   3120
      TabIndex        =   2
      Top             =   120
      Width           =   855
   End
   Begin VB.Label Label1 
      Caption         =   "will ceate ALARM when pump is warm or no sensors connected"
      Height          =   615
      Left            =   5280
      TabIndex        =   9
      Top             =   120
      Width           =   1695
   End
   Begin VB.Label eventslabel 
      Caption         =   "eventslabel"
      Height          =   255
      Left            =   240
      TabIndex        =   4
      Top             =   2640
      Width           =   6735
   End
   Begin VB.Label driveractivelabel 
      Caption         =   "driveractivelabel"
      Height          =   255
      Left            =   240
      TabIndex        =   3
      Top             =   2160
      Width           =   2175
   End
   Begin VB.Label portlabel 
      Caption         =   "no port found"
      Height          =   255
      Left            =   240
      TabIndex        =   1
      Top             =   240
      Width           =   2655
   End
   Begin VB.Label infolabel 
      Caption         =   "no pumpinfo found"
      Height          =   1095
      Left            =   240
      TabIndex        =   0
      Top             =   840
      Width           =   2895
   End
End
Attribute VB_Name = "D"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

'=================================================================
'NorhofDemo     VB6 application          by Emile Bisschop        V. 8.62   14-3-2020
'=================================================================

'!!!!! now the name of this form is D
' now you can type in the other forms and modules
'    d.gdrv.  and all options for gdrv are listed at the mouse

' the Demo1 project shows below all used code
' for expansions to Demo2, Demo3 etc, all extra code is listed below this first code every time,
' in the first part can be some small changes



' first install the Monitor pump software on this computer (with the NorhofInstall.exe from USBstick)
' it will create the C:\Program Files (x86)\NorhofPumpMonitor map in which the PumpMonitor.exe runs
' and                C:\NorhofLN2pump map
' and installs the driver Pump913drv.exe in the Windows System map (probably c:\Windows\SysWOW64\)


' needed for this program to run:
' this form          : NorhofDemo1.frm
' the driver         : Pump913drv.exe should be available for Windows in the
'                      ...\windows\system map (probably c:\Windows\SysWOW64\)
'                      and should be in the registry after installing the PumpMonitor program.
'pump should be connected to COM port 1-8

'NOTE: The driver is loaded ONE time when a Norhof program starts.
'      When the driver is loaded, a second program may start and will use the same loaded driver
'      so, you can run the PumpMonitor together with other programs, fe. your Demo1, AND demo2 AND demo3.
'      For every next program a new connection will be made, so you can see in the NorhofMonitor program
'      all values on screen, and compare it with the values you collect with your program
'!!  ADMINISTRATOR RIGHTS     24-5-20
'       all programs making use of the pump913drv.exe should be
'       OR all as administrator
'       OR all not as administrator
'       mixed will cause a second start up of the driver
'       this is in Windows 10, in Windows 7 it works always
'       I myself use NO administrator rights for all norhof programs
'!!  ADMINISTRATOR RIGHTS
'NOTE:VB6 IDE in Windows 10
'     setting VB6 on NO compatibility, gives a small screen extra on the primary monitor, what is disappeared
'        after minimizing and maximizing the VB6 IDE.
'        gives often ''method ~ of object ~ failed'' during load
'        but then works OK
'     setting compatibility to XP SP3, loads slower, but solves these,
'        but fails loading the same driver when IDE and exe runs together, after reboot


'Load this form in VB6 edditor (or with small modifications in any other language)
'This demo is in VB6, but could be easyly modified to other languages
'In the VB6 edditor:
'      make the reference to the driver, bij clicking Project, References,
'      browse, type = executable .exe files
'      find the Pum913drv.exe (probably c:\Windows\SysWOW64\)
'      and 'Norhof 600-900 pumps driver module' is added.
' The driver is defined as a classmodule to this program and will be loaded and started
' during this program if this is the only program connected to the driver

'Now this form should run (with Ctrl+F5 = run with full compile)

' this is minimal code for loading driver and checking if it is working
' no error handling is implemented yet, to keep it as simple as possible for now

'for other languages:
     'this form contains 3 labels and one commandbutton only
     ' this contains 4 form routines,     Form_Load,Form_Terminate,Form_Unload,readbutton_Click
     ' this contains 2 sub routines ,     DriverInit,DriverDisconnect



Public DriverActive As Boolean 'later we are collecting this for expansions of your program

Private gConn As pump913drv.Connector               ' Connection to Connector class
Public WithEvents gDrv As pump913drv.PumpMonitor    ' Connection to PumpMonitor class
Attribute gDrv.VB_VarHelpID = -1
                                         ' this receives the events from the driver

Private DriverDebugmode As Boolean

'========================================
'added in form declare for demo2
Private SlowpoLL9 As Boolean
Private SlowpoLL12 As Boolean
Private PingTimeStart
'========================================





Option Explicit '     always declare variables explicit, otherwise bugs are difficult to find

Private Sub Form_Load()
Dim aa
' place to init details for your program, minimal
' place to init details for your program, minimal
' place to init details for your program, minimal
Left = 400
Top = 1400
frmPump.Visible = False
    Call DriverInit  ' Start the driver
    
    DriverDebugmode = True ' shows info form from the driver, could be handy during debugging your program
    'should not be TRUE in your final application
    'if you remark this line below, all will act as it should be for the user
    aa = gDrv.SetDebug(DriverDebugmode) 'sets debug driver form visible
    
    Call readbutton_Click 'first read action will show com port, but not yet pumpinfo

' load further details for your program
' load further details for your program
' load further details for your program

'NOTE: this form has the PMonitor32x32_16M icon
   'in VB6, icons should be in 32x32 pixels, true color format, so that it also runs in older Windows versions
   'other icon formats gives errors in fe. XP

 


' ready, driver should run , but driveractive will be only TRUE after some seconds
 
' you could compile and run the .exe to check if that goes without errors
 
End Sub

'sub public, can be called from other forms
Public Sub Form_Terminate()
    Call DriverDisconnect ' IMPORTANT
    End ' in VB6 this ends this program
End Sub

'sub public, can be called from other forms
Public Sub Form_Unload(Cancel As Integer)
    Call DriverDisconnect ' IMPORTANT
    End ' in VB6 this ends this program
End Sub

 

 

Private Sub readbutton_Click()
   Dim portnumm%
    'port should be directly readable
    portnumm% = gDrv.RS232Get(5) 'function 5 is getting current com port number
    portlabel = "driver is on COM:" & portnumm%
    
' in demo2 this part in now moved to below to the gdrv_PumpReady routine
'    If Len(gdrv.PumpInfo) > 50 Then
'       'it takes some time before the driver if filled with parameters from the pump
'        If InStr(gdrv.PumpInfo, "pump") > 0 Then ' Norhof has more devices than pumps
'            'YES it is a pump
'            infolabel = gdrv.PumpInfo
'            DriverActive = True
'            ' for now to keep this simple, make driveractive TRUE when pumpinfo string is filled
'            ' later we will make a second check to see if also all slowpolls are received yet
'        End If
'    End If
'
'    driveractivelabel = "DriverActive =" & DriverActive
    
End Sub
'========================================================



'========= Demo1 routines


'Start the driver
Private Sub DriverInit()
    
    Set gConn = New Connector
    Set gDrv = gConn.PumpMonitor
      
    'driver will search for the correct device(Norhof pump) on port 1-8
    'when found, it will create a "Norport.sys" file in the C:\NorhofLN2pump map to make a second start faster
    'all next starts of the driver will first search for the correct device on this port
    '(if you manualy delete this file, the next start will search all 8 ports again first)
        ' NOTE: in version before, this "Norport.sys" was stored in the C:\Program Files (x86)\NorhofPumpMonitor map
        ' but in Windows 10 this was sometimes not accepted because of user licenses and/or passwords
        ' so since this version 8.62 we create this C:\NorhofLN2pump map and do all writing and reading of files here
    
    'driver connects to the pump, do an init by sending the "i" command to the pump
    'pump will return the info string, in which is the device name and version and date, to the driver
    'and will do directly some init commands by user polls (now 12)
    'gdrv.PumpInfo can be read to see if the driver is working and if the pump is connected and found
    'after that, the driver start sending poll commands to the pump, and the pump fills many register in the driver
    '   there are some fastpolls(now 3)   , one every 33 ms
    '   there are some polls    (now 4)   , form which one is send after all 3 fastpolls
    '   there are some slowpolls (now 12)  , from which one is send after all 4 polls
    '   more about this later
End Sub

Private Sub DriverDisconnect()
    ' driver must be unloaded when the last connection closes
    Set gDrv = Nothing
    Set gConn = Nothing
    DriverActive = False
    'added in Demo2
    SlowpoLL9 = False
    SlowpoLL12 = False
End Sub
 
 


'===========================================
'===========================================
' END of Demo1 code
'===========================================
'===========================================
'===========================================












'===========================================
'===========================================
' Demo2 code
'===========================================
'===========================================
'===========================================

'added above in form declare for demo2
'Private SlowpoLL9 As Boolean
'Private SlowpoLL12 As Boolean
'Private PingTimeStart

'after the driver is started, the driver sends polls to the pump, and after every poll
'the driver sends a receive event which could be captured by your program
'this is to notify that a value in the driver may have been changed by the pump
'the event tells you which data may have been changed

'this captures the PumpReady event from the driver
Private Sub gdrv_PumpReady(mCommand As prCommand, _
                           mPumpCommand As String, _
                           mbuffer As String)
 
 'some error capture can be done here
 
 If DriverActive = False Then
    'if driveractive = TRUE then no need to have events on this form any longer
    Call GetData(mCommand, mPumpCommand, mbuffer) 'local routine
   
 
  'HERE now we set the DriverActive to TRUE
  ' during an init by the driver, 12 poll commands are send, including slowpoll 10,11 and 12
  ' all other polls comes during the running time
  ' to be absolutely sure that one cycle of all polls is passed, the latest poll (nr 12) should have been captured
  ' but because an init sends also slowpoll 12,11 and 10, checking for slowpoll 9 is also needed
    
     If SlowpoLL9 = True And SlowpoLL12 = True Then 'all polls were received at least one time
        If Len(gDrv.PumpInfo) > 50 Then
       'it takes some time before the driver if filled with parameters from the pump
            If InStr(gDrv.PumpInfo, "pump") > 0 Then ' Norhof has more devices than pumps
                'YES it is a pump
                infolabel = gDrv.PumpInfo
                DriverActive = True
                '====================================
                'now  driveractive = TRUE when all registers in driver are filled
                'this is the only parameter we need from this form, for the rest of the program
                'from now on all eventcaptures can be directed to your program,
                'because all registers now should have values in the expected range
                
                'so, after driveractive = TRUE, we will redirect all events only to your program
                'so now this action runs only once
                Call getversionnumber
                
                frmPump.Visible = True 'now the rest can be shown
                    'now you could hide this startup form D if you want
                '====================================
                
            End If
        End If
     End If
    
    driveractivelabel = "DriverActive =" & DriverActive
 
 Else
    'in this demo3 all capture events are routed to Dispatcher.GetData
    Call Dispatcher.PumpReady(mCommand, mPumpCommand, mbuffer)
 
End If
 
End Sub


Private Sub GetData(mCommand As prCommand, mPumpCommand As String, mbuffer As String)

Dim tekkst$, test

eventslabel = mCommand & " " & mPumpCommand & "----" & mbuffer
'most events are numbered with mCommand (1-22)
'some events can be "other" (=23) and then should be recognised by the mPumpCommand string

    
'be sure there are NO Doevents during procedures called by this event capture
    
    Select Case mCommand
         'numbered commands
         Case 17 '= "i" prcPumpInfo  17 Get PumpInfo
              tekkst$ = gDrv.PumpInfo 'should be filled
         
         Case 6  'Stat_PortD  = "rm 32"    ' portD register, is slowpoll nr 9
              SlowpoLL9 = True
         Case 9  'Stat_EELN2  = "re 10 10" 'LN2 EEPROM values is slowpoll nr 12
              SlowpoLL12 = True
          
         
          
         
         Case prcOther '=23
            'UNnumbered commands
            Select Case mPumpCommand
                Case "rm 64" ' ping
                      pingbox = CLng((Timer - PingTimeStart) * 1000) & " ms"  ' in msec
                 
            End Select
         
         Case 1 To 23 'there are 22+1=23 numbered commands (now)
            'other numbered commands will pass here
            test = test 'for placing BREAK
         Case Else
            ' numbers >23
            'should not come
            test = test 'for placing BREAK
    End Select
    
    
End Sub


Private Sub POFbutton_Click() 'to switch the pump OFF
   Dim sc$
     sc$ = "pof"
     RSzendcopy sc$
End Sub

Private Sub PONbutton_Click() 'to switch the pump ON
   Dim sc$
     sc$ = "pon"
     RSzendcopy sc$
     'NOTE: depending on what type of pump, and in which working mode, and when the pump is not in the LN2, so warm,
     'and if sensors are connected or not, this may cause the pump to go into ALARM
End Sub

Private Sub pingbutton_Click()
     Dim sc$
     PingTimeStart = Timer
     sc$ = "rm 64" ' dummy read command, read memory place 64
                   ' just to check responce time
     RSzendcopy sc$

End Sub


Private Sub RSzendcopy(sc$) ' made local for this form only
         'later there will be a global routine RSzend
   Dim aa%
   Dim okbol As Boolean
    
      okbol = gDrv.PumpWrite(sc$)  ''
      If okbol = False Then aa% = MsgBox("error in sending pump command" & sc$)
    
   
End Sub

Private Sub getversionnumber()
   Dim versienr$, versienum$, plek%, rest$, tal%
    versienr$ = gDrv.PumpInfo$
        plek% = InStr(versienr$, "Version")
        If plek% > 0 Then
           If plek% + 9 < Len(versienr$) Then
              versienr$ = Mid$(versienr$, plek% + 9)
           End If
        End If
        
        If InStr(versienr$, Chr$(13)) > 0 Then
            F.sfversielabel = Left$(versienr$, InStr(versienr$, Chr$(13)) - 1 - 8)
            rest$ = Mid$(versienr$, InStr(versienr$, Chr$(13)) + 2)
            ''If InStr(rest$, Chr$(13)) > 0 Then
            '' vroeger zat blijkbaar crlf aan eind, nu niet meer, 2018
            If Len(rest$) > 15 Then
               ''rest$ = Left$(rest$, InStr(rest$, Chr$(13)) - 1)
               versienum$ = LTrim(Mid$(F.sfversielabel, 4))
                  F.sfversielabel = F.sfversielabel & Mid$(rest$, 7)
               If InStr(versienum$, ".") > 0 Then
                  tal% = InStr(versienum$, ".")
                  versienum$ = Left$(versienum$, tal% - 1) & Mid$(versienum$, tal% + 1)
                  VersieNummer% = Val(versienum$) 'global
               End If
            End If
         Else
            F.sfversielabel = " version not found"
         End If
End Sub




'===========================================
'===========================================
' Demo3 code
'===========================================
'===========================================
'===========================================

' in Demo3 a new form is added,            frmPump                 which could be your application form
' in Demo3 a new module(global) is added,  PumpDeclarations.bas    which contains all global variables
' in Demo3 a new module(global) is added,  PumpRoutines1.bas       which contains all global routines
' in Demo3 frmPump is made visible during Demo1_formload
 
' in Demo3
 




















 










