﻿'Author: Toby Scott
'Based on the NorhofPumpDrive form
'Needed for this library:
'this class file                   : NorhofNETWrapper.vb
'the drivermodule installed        : Pump913drv.exe
'       The drivermodule will be installed when the pumpmonitor
'       software is installed on the computer.
'       The Pump913drv.exe should be available for Windows in the
'       ...\windows\system or ...\windows\SysWOW64 folder and 
'       should be in the registry after the first time running.

'Building a .NET dll (different to windows dll):

'        For making this dll in Visual Basic .NET (VB)
'        simply build this class.
'        VB will first say 'user defined type not defined' (gConn)
'        Make the reference to the driver, by clicking Project, References,
'        browse, type= executable .exe files
'        find the Pum913drv.exe ( in ..windows\system)
'        and 'Norhof 600-900 pumps driver module' is added.
'        Now this should build.
'        Then use the .NET dll found in bin/debug/ to connect with 
'        LabVIEW or other .NET compatible language

Option Explicit On
Imports Pump913drv

Public Class NorhofNETWrapper
    Public gConn As Connector               ' Connection to Connector class
    Public WithEvents gDrv As PumpMonitor   ' Connection to PumpMonitor class
    ' this receives the events from the driver

    Private StartupDelay As Integer
    Private driveractive As Boolean
    Private driverDCmarked As Boolean = False
    Private DCdelay As Integer = 0
    Private strtemp As String
    Private n As Integer = 0
    Private mPTRes(327) As Double
    Private Const PTRANGEMIN = -200
    Private Const PTRANGEMAX = 125
    Private Const PTRESNULL = 100

    ' Variables available for application
    ' Note most of these are effectively read only as any write
    ' will be overwritten by the next driver interrupt
    Public PumpingMoode As Integer
    Public MainSensTemp As Integer
    Public ExtraSensorTemp As Integer
    Public Heater As Integer
    Public PumpStatus As Integer
    Public TempPotm As Integer
    Public AlarmVal As Integer
    Public DewarPress As Double
    Public FlowPreset As Double
    Public FlowDesired As Double
    Public PrePress As Double
    Public FeedingHeightOffset As Double
    Public FillTimeInterval As String
    Public FillTimeTogo As String
    Public NULmbaroffet As Integer
    Public Dewarlevel As Double ' In cm
    Public Serial As String
    Public model As String
    Public Temp As Integer
    Public Flow As Integer
    Public Control As Integer

    'Start the driver
    Public Function DriverInit() As Boolean
        driverDCmarked = False
        driveractive = False
        gConn = New Connector
        gDrv = gConn.PumpMonitor
        Define_Pt100_temp()
        Do While Not driveractive
            If n = 100 Then '10 seconds waited
                MsgBox("Driver Timeout")
                DriverDisconnect()
                Return False
            End If
            n += 1
            Threading.Thread.Sleep(100)
        Loop
        Return True
    End Function

    Public Sub DriverDisconnect()
        driverDCmarked = True ' Mark driver for disconnection
        n = 0
        Do While driveractive
            Threading.Thread.Sleep(100)
            n = n + 1
            If n > 150 Then ' Timeout on disconnect
                DriverDC()
            End If
        Loop
    End Sub

    Private Sub DriverDC()
        ' Driver must be unloaded when the last connection closes
        gDrv = Nothing
        gConn = Nothing
        driveractive = False
    End Sub

    ' Interupt routine from driver to application
    ' Route the events to DrvInterface.GetData....
    ' This routine wil call the correct connector to get the data from the driver
    ' Values in the driver are updated automaticly by the pump.
    ' Most parameters are updates every .1 second (most analogue values)
    ' Some values are updates every .9 second ( system clock and RS232 parameters)
    ' Some values are updates every 5 seconds (serial number, sofware version .....)
    ' When an update is made in the driver, this routine is called.
    ' use gDrv.* to update variables in your application
    '-------------------------------------------------------------------------
    Public Sub gDrv_PumpReady(ByRef mCommand As prCommand, ByRef mPumpCommand As String, ByRef mBuffer As String) Handles gDrv.PumpReady

        On Error GoTo erringetdata

        ' Disconnects the driver when marked, calling here ensures all
        ' RS232 commands have been completed
        If driverDCmarked Then
            DCdelay += 1 ' ensures no race condition occurs
            If DCdelay > 2 Then
                DriverDC()
            End If
        ElseIf driveractive = True Then
            'Call GetData(mCommand, mPumpCommand, mBuffer)
            'Debug.Print "Event command: " & mCommand, "Pump command: " & mPumpCommand, " buffer: " & mBuffer

            Select Case mCommand

                Case prCommand.prcREADregstL  'set of  10 * 8 bit registers
                    ' called every 100 mSec.
                    ' 0 pumpstatus
                    PumpStatus = gDrv.PumpRegister(regRequest.regPumpStatus) ' 0=sleep   1=active  3= pumping
                    ' 1 qstartreg
                    ' 2 PortC = leds
                    ' 3 alarm
                    AlarmVal = gDrv.PumpRegister(regRequest.regAlarm)
                    ' 4 pump mode
                    PumpingMoode = gDrv.PumpRegister(regRequest.regPumpMode)
                    ' 5 heatervalue
                    Heater = gDrv.PumpRegister(regRequest.regHeaterValue)    ' 0-255 == 0-100%
                    ' 6 FLpercent
                    ' 7 TEMfloat floating offset used internal for external heater
                    ' 8 EXTheat  TEMheat
                    ' 9 TMB difference


                Case prCommand.prcREADregstH ' 5 * 16 bit registers
                    ' called every 100 mSec.
                    ' 0 compare temperature PID
                    ' 1 temp preset
                    ' 2 flow preset
                    NULmbaroffet = gDrv.Preset(prRequest.rePressure, prResult.prcold)
                    PrePress = CDbl(gDrv.Preset(prRequest.rePressure, prResult.prWarm) - NULmbaroffet) * 0.542888 ' prepressure

                    FeedingHeightOffset = CDbl(gDrv.Preset(prRequest.rePresCo2, prResult.prcold)) * 0.542888

                    FlowDesired = gDrv.ADC(Sensor.snFlowgewenst, Result.rsMbar) + PrePress + FeedingHeightOffset ' is overpressure from potmeter on pump
                    ' 3 supply voltage
                    ' 4 prePressure

                Case prCommand.prcAnalogValues
                    ' called every 100 mSec.
                    strtemp = gDrv.ADC(Sensor.snMain, Result.rsTemprature)     ' main external sensor
                    MainSensTemp = removeGTLT(strtemp)
                    strtemp = gDrv.ADC(Sensor.snextra, Result.rsTemprature)   'extra sensor
                    ExtraSensorTemp = removeGTLT(strtemp)
                    DewarPress = gDrv.ADC(Sensor.snPressure, Result.rsMbar)         ' dewar pressure

                    'gDrv.ADC(snExtra, rsTemprature))              ' extra external sensor
                    'gDrv.ADC(snExternAnalog, rsInt))              ' analogue input flow

                    Dewarlevel = CInt(CDbl((gDrv.Preset(prRequest.rePresCo2, prResult.prWarm) - NULmbaroffet)) * 0.542888 / 0.808 * 10 + 20) / 10


                    FeedingHeightOffset = CDbl(gDrv.Preset(prRequest.rePresCo2, prResult.prcold)) * 0.542888

                    If PumpingMoode = 15 Then
                        FlowPreset = Val(gDrv.RS232Get(RScon.rscFlow)) + PrePress + FeedingHeightOffset
                    Else
                        If (PumpingMoode = 13) Or (PumpingMoode = 14) Then
                            FlowPreset = gDrv.ADC(Sensor.snFlowgewenst, Result.rsMbar) * Val(gDrv.RS232Get(RScon.rscFlow)) / 100 + PrePress + FeedingHeightOffset
                        Else
                            FlowPreset = FlowDesired
                        End If
                    End If

                    strtemp = gDrv.ADC(Sensor.snTempSetpoint, Result.rsTemprature) ' temp preset potmeter on pump
                    TempPotm = removeGTLT(strtemp)

                Case prCommand.prcTimeTimerCurrent
                    FillTimeInterval = gDrv.PumpTimer(TimeRequest.trTimerCurrent) ' time until next filling
                Case prCommand.prcTimeTimerPresetMem
                    FillTimeTogo = gDrv.PumpTimer(TimeRequest.trEETimerPreset)    ' filling interval time



                Case prCommand.prcRS232
                    ' called every 900 mSec.
                    strtemp = gDrv.RS232Get(RScon.rscTemprature)
                    Temp = removeGTLT(strtemp)
                    If PumpingMoode = 14 Then
                        Flow = gDrv.RS232Get(RScon.rscFlow)  ' is procents from 1023
                    Else
                        Flow = gDrv.RS232Get(RScon.rscFlow) ' is flow in mBar.
                    End If

                    Control = gDrv.RS232Get(RScon.rscControl)
            End Select

        Else
            ' wait until driver is initialised
            If StartupDelay > 5 Then

                Select Case mCommand

                    Case prCommand.prcRS232
                        strtemp = gDrv.RS232Get(RScon.rscTemprature)
                        Temp = removeGTLT(strtemp)
                        Flow = gDrv.RS232Get(RScon.rscFlow)
                        Control = gDrv.RS232Get(RScon.rscControl)
                    Case prCommand.prcPumpSerial
                        ' called every 5000 mSec.
                        'wait for serialnumber event before
                        ' starting application
                        Serial = gDrv.PumpSerialNumber
                        model = Left(Serial, 1)
                        Select Case model
                            Case "F"
                                Serial = "#815 20" & Mid(Serial, 3)
                            Case "E"
                                Serial = "#810 20" & Mid(Serial, 3)
                            Case "D"
                                Serial = "#805 20" & Mid(Serial, 3)

                            Case "C"
                                Serial = "#915 20" & Mid(Serial, 3)
                            Case "B"
                                Serial = "#910 20" & Mid(Serial, 3)
                            Case "A"
                                Serial = "#905 20" & Mid(Serial, 3)

                            Case "1"
                                Serial = "#605 20" & Mid(Serial, 3)
                            Case "2"
                                Serial = "#606 20" & Mid(Serial, 3)
                            Case "3"
                                Serial = "#607 20" & Mid(Serial, 3)
                            Case "4"
                                Serial = "#608 20" & Mid(Serial, 3)
                            Case "5"
                                Serial = "#609 20" & Mid(Serial, 3)
                        End Select
                        driveractive = True
                End Select
            Else
                StartupDelay = StartupDelay + 1
            End If
        End If

eruit:
        Exit Sub

erringetdata:
        'Stop
        If Err.Number = -2147417843 Then Resume eruit ' error whem minimised, skip
        'Stop
        MsgBox("error in getdata, err:" & Err.Description)
        Resume eruit

    End Sub

    Function setcomport(comnumber As Integer) As Boolean
        Return gDrv.CommPort(comnumber)
    End Function


    '===========================================================================
    '===========================================================================
    '===========================================================================
    '===========================================================================
    '===========================================================================
    '===========================================================================
    ' below the 3 commands to give input to the pump
    ' return true after successful write
    ' return false if the value is out of range or pump not connected

    Public Function SetContr(ByVal ContrSet As Integer) As Boolean ' only in mode "E" and "F"
        Return gDrv.RS232Set(RScon.rscControl, ContrSet)
    End Function

    Public Function SetFlow(ByVal FlowSet As Integer) As Boolean ' only in mode "E" and "F"
        Return gDrv.RS232Set(RScon.rscFlow, FlowSet)
    End Function

    Public Function SetTemp(ByVal TempSet As Integer) As Boolean ' only in mode "E"
        Return gDrv.RS232Set(RScon.rscTemprature, TempSet)
    End Function

    '===========================================================================
    '===========================================================================
    '===========================================================================
    '===========================================================================
    '===========================================================================
    '===========================================================================
    '===========================================================================
    ' example commands to read the pump directly, not based on interrupts
    ' may be  needed to refresh, or to be sure that the data is correct

    Public Function getmainsensortemperature(ByRef mainTemp As Double) As Boolean ' Use for 1 d.p. accuracy
        mainTemp = AnaToTemp(Sensor.snMain)
        Return driveractive
    End Function

    Public Function getextrasensortemperature(ByRef extraTemp As Double) As Boolean ' Use for 1 d.p. accuracy
        extraTemp = AnaToTemp(Sensor.snextra)
        Return driveractive
    End Function

    Public Function getpressure(ByRef pressure As Integer) As Boolean
        pressure = gDrv.ADC(Sensor.snPressure, Result.rsMbar)
        Return driveractive
    End Function

    Public Function getheater(ByRef heater As Integer) As Boolean
        heater = gDrv.PumpRegister(regRequest.regHeaterValue)
        Return driveractive
    End Function

    Public Function getpumpstatus(ByRef pumpget As Integer) As Boolean
        pumpget = gDrv.PumpRegister(regRequest.regPumpStatus)
        Return driveractive
    End Function

    'Public Function str(ByRef in1 As String, ByVal in2 As String) As String 'dll test function
    '    in2 = in2 & "hi"
    '    in1 = in1 & "hi"
    '    Return "test" & in2 & in1
    'End Function


    'Public Function add(ByVal a As Integer, ByVal b As Integer) As Integer 'dll/driver test function
    '    Dim s As String

    '    s = "<2"

    '    If (s.First = ">") Or (s.First = "<") Then
    '        s = Right(s, Len(s) - 1)
    '    End If

    '    Return a + b + RScon.rscControl - Val(s)
    'End Function

    Public Function Ser() As String ' Manually get serial
        Serial = gDrv.PumpSerialNumber
        model = Left(Serial, 1)
        Select Case model
            Case "F"
                Serial = "#815 20" & Mid(Serial, 3)
            Case "E"
                Serial = "#810 20" & Mid(Serial, 3)
            Case "D"
                Serial = "#805 20" & Mid(Serial, 3)

            Case "C"
                Serial = "#915 20" & Mid(Serial, 3)
            Case "B"
                Serial = "#910 20" & Mid(Serial, 3)
            Case "A"
                Serial = "#905 20" & Mid(Serial, 3)

            Case "1"
                Serial = "#605 20" & Mid(Serial, 3)
            Case "2"
                Serial = "#606 20" & Mid(Serial, 3)
            Case "3"
                Serial = "#607 20" & Mid(Serial, 3)
            Case "4"
                Serial = "#608 20" & Mid(Serial, 3)
            Case "5"
                Serial = "#609 20" & Mid(Serial, 3)
        End Select

        Ser = Serial
    End Function

    Private Function removeGTLT(s As String) As Integer
        If (s.First = ">") Or (s.First = "<") Then
            Return CInt(Right(s, Len(s) - 1))
        End If
        Return CInt(s)
    End Function

    Private Function AnaToTemp(mSensor As Sensor) As Double
        Dim CurrentPos As Double
        Dim LastTopPos As Integer
        Dim LastBottomPos As Integer
        Dim res

        Select Case mSensor
            Case Sensor.snVessel, Sensor.snTMB, Sensor.snextra, Sensor.snMain
                'Get a resistance <-- Volt <-- analog value
                res = gDrv.ADC(mSensor, Result.rsResistance)

                '****** Get temp from Array ******

                'First see if the resistance is in the table range
                If (res <= mPTRes(200 + PTRANGEMAX)) And (res >= mPTRes(200 + PTRANGEMIN)) Then

                    'Get a starting point in the middle of the array
                    CurrentPos = 200 + PTRANGEMIN + ((PTRANGEMAX - PTRANGEMIN) \ 2)
                    LastTopPos = 200 + PTRANGEMAX
                    LastBottomPos = 200 + PTRANGEMIN

                    'Start binary search
                    Do While Not (res < mPTRes(CurrentPos + 1) And res >= mPTRes(CurrentPos))
                        If res < mPTRes(CurrentPos) Then
                            LastTopPos = CurrentPos
                        Else
                            LastBottomPos = CurrentPos
                        End If
                        'Get new position half way
                        CurrentPos = LastBottomPos + ((LastTopPos - LastBottomPos) \ 2)
                    Loop

                    'Combine integer and calculated float
                    Return CurrentPos - 200 + Math.Round(Math.Round(res - mPTRes(CurrentPos), 2) * (1 / Math.Round((mPTRes(CurrentPos + 1) - mPTRes(CurrentPos)), 2)), 1)

                Else
                    If res <= mPTRes(200 + PTRANGEMAX) Then
                        Return PTRANGEMIN
                    Else
                        Return PTRANGEMAX
                    End If
                End If

            Case Else
                Return Nothing

        End Select

    End Function

    Private Sub Define_Pt100_temp()

        mPTRes(200 + 126) = 148.66  ' moet blijkbaar even aantal zijn
        mPTRes(200 + 125) = 148.32  ' 125 degrees
        mPTRes(200 + 124) = 147.94
        mPTRes(200 + 123) = 147.56
        mPTRes(200 + 122) = 147.18
        mPTRes(200 + 121) = 146.8
        mPTRes(200 + 120) = 146.42
        mPTRes(200 + 119) = 146.03
        mPTRes(200 + 118) = 145.65
        mPTRes(200 + 117) = 145.27   ' dit stuk klopt niet hoor
        mPTRes(200 + 116) = 144.89   ' is gejat van hier beneden
        mPTRes(200 + 115) = 144.5
        mPTRes(200 + 114) = 144.12
        mPTRes(200 + 113) = 143.73
        mPTRes(200 + 112) = 143.35
        mPTRes(200 + 111) = 142.96
        mPTRes(200 + 110) = 142.58
        mPTRes(200 + 109) = 142.19
        mPTRes(200 + 108) = 141.81
        mPTRes(200 + 107) = 141.42
        mPTRes(200 + 106) = 141.03
        mPTRes(200 + 105) = 140.65
        mPTRes(200 + 104) = 140.26
        mPTRes(200 + 103) = 139.88
        mPTRes(200 + 102) = 139.49
        mPTRes(200 + 101) = 139.11
        mPTRes(200 + 100) = 138.7   ' 100 degrees
        mPTRes(200 + 99) = 138.32
        mPTRes(200 + 98) = 137.94
        mPTRes(200 + 97) = 137.56
        mPTRes(200 + 96) = 137.18
        mPTRes(200 + 95) = 136.8
        mPTRes(200 + 94) = 136.42
        mPTRes(200 + 93) = 136.03
        mPTRes(200 + 92) = 135.65
        mPTRes(200 + 91) = 135.27
        mPTRes(200 + 90) = 134.89
        mPTRes(200 + 89) = 134.5
        mPTRes(200 + 88) = 134.12
        mPTRes(200 + 87) = 133.73
        mPTRes(200 + 86) = 133.35
        mPTRes(200 + 85) = 132.96
        mPTRes(200 + 84) = 132.58
        mPTRes(200 + 83) = 132.19
        mPTRes(200 + 82) = 131.81
        mPTRes(200 + 81) = 131.42
        mPTRes(200 + 80) = 131.03
        mPTRes(200 + 79) = 130.65
        mPTRes(200 + 78) = 130.26
        mPTRes(200 + 77) = 129.88
        mPTRes(200 + 76) = 129.49
        mPTRes(200 + 75) = 129.11
        mPTRes(200 + 74) = 128.72
        mPTRes(200 + 73) = 128.33
        mPTRes(200 + 72) = 127.94
        mPTRes(200 + 71) = 127.56
        mPTRes(200 + 70) = 127.17
        mPTRes(200 + 69) = 126.78
        mPTRes(200 + 68) = 126.4
        mPTRes(200 + 67) = 126.01
        mPTRes(200 + 66) = 125.62
        mPTRes(200 + 65) = 125.23
        mPTRes(200 + 64) = 124.85
        mPTRes(200 + 63) = 124.46
        mPTRes(200 + 62) = 124.07
        mPTRes(200 + 61) = 123.68
        mPTRes(200 + 60) = 123.29
        mPTRes(200 + 59) = 122.9
        mPTRes(200 + 58) = 122.51
        mPTRes(200 + 57) = 122.13
        mPTRes(200 + 56) = 121.74
        mPTRes(200 + 55) = 121.35
        mPTRes(200 + 54) = 120.96
        mPTRes(200 + 53) = 120.57
        mPTRes(200 + 52) = 120.18
        mPTRes(200 + 51) = 119.79
        mPTRes(200 + 50) = 119.4    '50 degrees
        mPTRes(200 + 49) = 119.01
        mPTRes(200 + 48) = 118.62
        mPTRes(200 + 47) = 118.24
        mPTRes(200 + 46) = 117.85
        mPTRes(200 + 45) = 117.47
        mPTRes(200 + 44) = 117.08
        mPTRes(200 + 43) = 116.7
        mPTRes(200 + 42) = 116.31
        mPTRes(200 + 41) = 115.93
        mPTRes(200 + 40) = 115.54
        mPTRes(200 + 39) = 115.15
        mPTRes(200 + 38) = 114.77
        mPTRes(200 + 37) = 114.38
        mPTRes(200 + 36) = 113.99
        mPTRes(200 + 35) = 113.61
        mPTRes(200 + 34) = 113.22
        mPTRes(200 + 33) = 112.83
        mPTRes(200 + 32) = 112.45
        mPTRes(200 + 31) = 112.06
        mPTRes(200 + 30) = 111.67
        mPTRes(200 + 29) = 111.28
        mPTRes(200 + 28) = 110.9
        mPTRes(200 + 27) = 110.51
        mPTRes(200 + 26) = 110.12
        mPTRes(200 + 25) = 109.73
        mPTRes(200 + 24) = 109.35
        mPTRes(200 + 23) = 108.96
        mPTRes(200 + 22) = 108.57
        mPTRes(200 + 21) = 108.18
        mPTRes(200 + 20) = 107.79
        mPTRes(200 + 19) = 107.4
        mPTRes(200 + 18) = 107.02
        mPTRes(200 + 17) = 106.63
        mPTRes(200 + 16) = 106.24
        mPTRes(200 + 15) = 105.85
        mPTRes(200 + 14) = 105.46
        mPTRes(200 + 13) = 105.07
        mPTRes(200 + 12) = 104.68
        mPTRes(200 + 11) = 104.29
        mPTRes(200 + 10) = 103.9
        mPTRes(200 + 9) = 103.51
        mPTRes(200 + 8) = 103.12
        mPTRes(200 + 7) = 102.73
        mPTRes(200 + 6) = 102.34
        mPTRes(200 + 5) = 101.95
        mPTRes(200 + 4) = 101.56
        mPTRes(200 + 3) = 101.17
        mPTRes(200 + 2) = 100.78
        mPTRes(200 + 1) = 100.39
        mPTRes(200) = 100             ' 0 degrees
        mPTRes(200 - 1) = 99.61
        mPTRes(200 - 2) = 99.22
        mPTRes(200 - 3) = 98.83
        mPTRes(200 - 4) = 98.44
        mPTRes(200 - 5) = 98.04
        mPTRes(200 - 6) = 97.65
        mPTRes(200 - 7) = 97.26
        mPTRes(200 - 8) = 96.87
        mPTRes(200 - 9) = 96.48
        mPTRes(200 - 10) = 96.09
        mPTRes(200 - 11) = 95.69
        mPTRes(200 - 12) = 95.3
        mPTRes(200 - 13) = 94.91
        mPTRes(200 - 14) = 94.52
        mPTRes(200 - 15) = 94.12
        mPTRes(200 - 16) = 93.73
        mPTRes(200 - 17) = 93.34
        mPTRes(200 - 18) = 92.95
        mPTRes(200 - 19) = 92.55
        mPTRes(200 - 20) = 92.16
        mPTRes(200 - 21) = 91.77
        mPTRes(200 - 22) = 91.37
        mPTRes(200 - 23) = 90.98
        mPTRes(200 - 24) = 90.59
        mPTRes(200 - 25) = 90.19
        mPTRes(200 - 26) = 89.8
        mPTRes(200 - 27) = 89.4
        mPTRes(200 - 28) = 89.01
        mPTRes(200 - 29) = 88.62
        mPTRes(200 - 30) = 88.22
        mPTRes(200 - 31) = 87.83
        mPTRes(200 - 32) = 87.43
        mPTRes(200 - 33) = 87.04
        mPTRes(200 - 34) = 86.64
        mPTRes(200 - 35) = 86.25
        mPTRes(200 - 36) = 85.85
        mPTRes(200 - 37) = 85.46
        mPTRes(200 - 38) = 85.06
        mPTRes(200 - 39) = 84.67
        mPTRes(200 - 40) = 84.27
        mPTRes(200 - 41) = 83.88
        mPTRes(200 - 42) = 83.48
        mPTRes(200 - 43) = 83.08
        mPTRes(200 - 44) = 82.69
        mPTRes(200 - 45) = 82.29
        mPTRes(200 - 46) = 81.89
        mPTRes(200 - 47) = 81.5
        mPTRes(200 - 48) = 81.1
        mPTRes(200 - 49) = 80.7
        mPTRes(200 - 50) = 80.31         ' -50 degrees
        mPTRes(200 - 51) = 79.91
        mPTRes(200 - 52) = 79.51
        mPTRes(200 - 53) = 79.11
        mPTRes(200 - 54) = 78.72
        mPTRes(200 - 55) = 78.32
        mPTRes(200 - 56) = 77.92
        mPTRes(200 - 57) = 77.52
        mPTRes(200 - 58) = 77.13
        mPTRes(200 - 59) = 76.73
        mPTRes(200 - 60) = 76.33
        mPTRes(200 - 61) = 75.93
        mPTRes(200 - 62) = 75.53
        mPTRes(200 - 63) = 75.13
        mPTRes(200 - 64) = 74.73
        mPTRes(200 - 65) = 74.33
        mPTRes(200 - 66) = 73.93
        mPTRes(200 - 67) = 73.53
        mPTRes(200 - 68) = 73.13
        mPTRes(200 - 69) = 72.73
        mPTRes(200 - 70) = 72.33
        mPTRes(200 - 71) = 71.93
        mPTRes(200 - 72) = 71.53
        mPTRes(200 - 73) = 71.13
        mPTRes(200 - 74) = 70.73
        mPTRes(200 - 75) = 70.33
        mPTRes(200 - 76) = 69.93
        mPTRes(200 - 77) = 69.53
        mPTRes(200 - 78) = 69.13
        mPTRes(200 - 79) = 68.73
        mPTRes(200 - 80) = 68.33
        mPTRes(200 - 81) = 67.92
        mPTRes(200 - 82) = 67.52
        mPTRes(200 - 83) = 67.12
        mPTRes(200 - 84) = 66.72
        mPTRes(200 - 85) = 66.31
        mPTRes(200 - 86) = 65.91
        mPTRes(200 - 87) = 65.51
        mPTRes(200 - 88) = 65.11
        mPTRes(200 - 89) = 64.7
        mPTRes(200 - 90) = 64.3
        mPTRes(200 - 91) = 63.9
        mPTRes(200 - 92) = 63.49
        mPTRes(200 - 93) = 63.09
        mPTRes(200 - 94) = 62.68
        mPTRes(200 - 95) = 62.28
        mPTRes(200 - 96) = 61.87
        mPTRes(200 - 97) = 61.47
        mPTRes(200 - 98) = 61.06
        mPTRes(200 - 99) = 60.66
        mPTRes(200 - 100) = 60.25        ' -100 degrees
        mPTRes(200 - 101) = 59.85
        mPTRes(200 - 102) = 59.44
        mPTRes(200 - 103) = 59.04
        mPTRes(200 - 104) = 58.63
        mPTRes(200 - 105) = 58.22
        mPTRes(200 - 106) = 57.82
        mPTRes(200 - 107) = 57.41
        mPTRes(200 - 108) = 57
        mPTRes(200 - 109) = 56.6
        mPTRes(200 - 110) = 56.19
        mPTRes(200 - 111) = 55.78
        mPTRes(200 - 112) = 55.38
        mPTRes(200 - 113) = 54.97
        mPTRes(200 - 114) = 54.56
        mPTRes(200 - 115) = 54.15
        mPTRes(200 - 116) = 53.74
        mPTRes(200 - 117) = 53.33
        mPTRes(200 - 118) = 52.92
        mPTRes(200 - 119) = 52.52
        mPTRes(200 - 120) = 52.11
        mPTRes(200 - 121) = 51.7
        mPTRes(200 - 122) = 51.29
        mPTRes(200 - 123) = 50.88
        mPTRes(200 - 124) = 50.47
        mPTRes(200 - 125) = 50.06
        mPTRes(200 - 126) = 49.64
        mPTRes(200 - 127) = 49.23
        mPTRes(200 - 128) = 48.82
        mPTRes(200 - 129) = 48.41
        mPTRes(200 - 130) = 48
        mPTRes(200 - 131) = 47.59
        mPTRes(200 - 132) = 47.18
        mPTRes(200 - 133) = 46.76
        mPTRes(200 - 134) = 46.35
        mPTRes(200 - 135) = 45.94
        mPTRes(200 - 136) = 45.52
        mPTRes(200 - 137) = 45.11
        mPTRes(200 - 138) = 44.7
        mPTRes(200 - 139) = 44.28
        mPTRes(200 - 140) = 43.87
        mPTRes(200 - 141) = 43.45
        mPTRes(200 - 142) = 43.04
        mPTRes(200 - 143) = 42.63
        mPTRes(200 - 144) = 42.21
        mPTRes(200 - 145) = 41.79
        mPTRes(200 - 146) = 41.38
        mPTRes(200 - 147) = 40.96
        mPTRes(200 - 148) = 40.55
        mPTRes(200 - 149) = 40.13
        mPTRes(200 - 150) = 39.71        ' -150 degrees
        mPTRes(200 - 151) = 39.3
        mPTRes(200 - 152) = 38.88
        mPTRes(200 - 153) = 38.46
        mPTRes(200 - 154) = 38.04
        mPTRes(200 - 155) = 37.63
        mPTRes(200 - 156) = 37.21
        mPTRes(200 - 157) = 36.79
        mPTRes(200 - 158) = 36.37
        mPTRes(200 - 159) = 35.95
        mPTRes(200 - 160) = 35.53
        mPTRes(200 - 161) = 35.11
        mPTRes(200 - 162) = 34.69
        mPTRes(200 - 163) = 34.27
        mPTRes(200 - 164) = 33.85
        mPTRes(200 - 165) = 33.43
        mPTRes(200 - 166) = 33.01
        mPTRes(200 - 167) = 32.59
        mPTRes(200 - 168) = 32.16
        mPTRes(200 - 169) = 31.74
        mPTRes(200 - 170) = 31.32
        mPTRes(200 - 171) = 30.9
        mPTRes(200 - 172) = 30.47
        mPTRes(200 - 173) = 30.05
        mPTRes(200 - 174) = 29.63
        mPTRes(200 - 175) = 29.2
        mPTRes(200 - 176) = 28.78
        mPTRes(200 - 177) = 28.35
        mPTRes(200 - 178) = 27.93
        mPTRes(200 - 179) = 27.5
        mPTRes(200 - 180) = 27.08
        mPTRes(200 - 181) = 26.65
        mPTRes(200 - 182) = 26.23
        mPTRes(200 - 183) = 25.8
        mPTRes(200 - 184) = 25.37
        mPTRes(200 - 185) = 24.94
        mPTRes(200 - 186) = 24.52
        mPTRes(200 - 187) = 24.09
        mPTRes(200 - 188) = 23.66
        mPTRes(200 - 189) = 23.23
        mPTRes(200 - 190) = 22.8
        mPTRes(200 - 191) = 22.37
        mPTRes(200 - 192) = 21.94
        mPTRes(200 - 193) = 21.51
        mPTRes(200 - 194) = 21.08
        mPTRes(200 - 195) = 20.65
        mPTRes(200 - 196) = 20.22
        mPTRes(200 - 197) = 19.79
        mPTRes(200 - 198) = 19.36
        mPTRes(200 - 199) = 18.93
        mPTRes(200 - 200) = 18.49        ' -200 degrees

    End Sub

End Class

