VERSION 5.00
Begin VB.Form Demo1 
   Caption         =   "NorhofDemo1"
   ClientHeight    =   3135
   ClientLeft      =   60
   ClientTop       =   405
   ClientWidth     =   4680
   Icon            =   "NorhofDemo1.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   3135
   ScaleWidth      =   4680
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton readbutton 
      Caption         =   "read"
      Height          =   375
      Left            =   3360
      TabIndex        =   2
      Top             =   360
      Width           =   855
   End
   Begin VB.Label driveractivelabel 
      Caption         =   "driveractivelabel"
      Height          =   255
      Left            =   240
      TabIndex        =   3
      Top             =   2160
      Width           =   2175
   End
   Begin VB.Label portlabel 
      Caption         =   "no port found"
      Height          =   255
      Left            =   240
      TabIndex        =   1
      Top             =   240
      Width           =   2655
   End
   Begin VB.Label infolabel 
      Caption         =   "no pumpinfo found"
      Height          =   1095
      Left            =   240
      TabIndex        =   0
      Top             =   840
      Width           =   2895
   End
End
Attribute VB_Name = "Demo1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

'=================================================================
'NorhofDemo     VB6 application          by Emile Bisschop        V. 8.62   14-3-2020
'=================================================================

' the Demo1 project shows below all used code
' for expansions to Demo2, Demo3 etc, all extra code is listed below this first code every time,
' in the first part can be some small changes



' first install the Monitor pump software on this computer (with the NorhofInstall.exe from USBstick)
' it will create the C:\Program Files (x86)\NorhofPumpMonitor map in which the PumpMonitor.exe runs
' and                C:\NorhofLN2pump map
' and installs the driver Pump913drv.exe in the Windows System map (probably c:\Windows\SysWOW64\)


' needed for this program to run:
' this form          : NorhofDemo1.frm
' the driver         : Pump913drv.exe should be available for Windows in the
'                      ...\windows\system map (probably c:\Windows\SysWOW64\)
'                      and should be in the registry after installing the PumpMonitor program.
'pump should be connected to COM port 1-8

'NOTE: The driver is loaded ONE time when a Norhof program starts.
'      When the driver is loaded, a second program may start and will use the same loaded driver
'      so, you can run the PumpMonitor together with other programs, fe. your Demo1, AND demo2 AND demo3.
'      For every next program a new connection will be made, so you can see in the NorhofMonitor program
'      all values on screen, and compare it with the values you collect with your program
'!!  ADMINISTRATOR RIGHTS     24-5-20
'       all programs making use of the pump913drv.exe should be
'       OR all as administrator
'       OR all not as administrator
'       mixed will cause a second start up of the driver
'       this is in Windows 10, in Windows 7 it works always
'       I myself use NO administrator rights for all norhof programs
'!!  ADMINISTRATOR RIGHTS
'NOTE:VB6 IDE in Windows 10
'     setting VB6 on NO compatibility, gives a small screen extra on the primary monitor, what is disappeared
'        after minimizing and maximizing the VB6 IDE.
'        gives often ''method ~ of object ~ failed'' during load
'        but then works OK
'     setting compatibility to XP SP3, loads slower, but solves these,
'        but fails loading the same driver when IDE and exe runs together, after reboot


'Load this form in VB6 edditor (or with small modifications in any other language)
'This demo is in VB6, but could be easyly modified to other languages
'In the VB6 edditor:
'      make the reference to the driver, bij clicking Project, References,
'      browse, type = executable .exe files
'      find the Pum913drv.exe (probably c:\Windows\SysWOW64\)
'      and 'Norhof 600-900 pumps driver module' is added.
' The driver is defined as a classmodule to this program and will be loaded and started
' during this program if this is the only program connected to the driver

'Now this form should run (with Ctrl+F5 = run with full compile)

' this is minimal code for loading driver and checking if it is working
' no error handling is implemented yet, to keep it as simple as possible for now

'for other languages:
     'this form contains 3 labels and one commandbutton only
     ' this contains 4 form routines,     Form_Load,Form_Terminate,Form_Unload,readbutton_Click
     ' this contains 2 sub routines ,     DriverInit,DriverDisconnect



Public DriverActive As Boolean 'later we are collecting this for expansions of your program

Private gConn As Connector               ' Connection to Connector class
Public WithEvents Ddrv As PumpMonitor   ' Connection to PumpMonitor class
Attribute Ddrv.VB_VarHelpID = -1
                                         ' this receives the events from the driver

Private DriverDebugmode As Boolean

Option Explicit '     always declare variables explicit, otherwise bugs are difficult to find

Private Sub Form_Load()
Dim aa
' place to init details for your program, minimal
' place to init details for your program, minimal
' place to init details for your program, minimal


    Call DriverInit  ' Start the driver
    
    DriverDebugmode = True ' shows info form from the driver, could be handy during debugging your program
    'should not be TRUE in your final application
    'if you remark this line below, all will act as it should be for the user
    aa = Ddrv.SetDebug(DriverDebugmode) 'sets debug driver form visible
    
    Call readbutton_Click 'first read action will show com port, but not yet pumpinfo
               '!! 20-9-2020  because of a changement in the driver, also the pumpinfo is there directly after init

' load further details for your program
' load further details for your program
' load further details for your program

'NOTE: this form has the PMonitor32x32_16M icon
   'in VB6, icons should be in 32x32 pixels, true color format, so that it also runs in older Windows versions
   'other icon formats gives errors in fe. XP




' ready, driver should run , but driveractive will be only TRUE after some seconds
 
' you could compile and run the .exe to check if that goes without errors
 
End Sub

'sub public, can be called from other forms
Public Sub Form_Terminate()
    Call DriverDisconnect ' IMPORTANT
    End ' in VB6 this ends this program
End Sub

'sub public, can be called from other forms
Public Sub Form_Unload(Cancel As Integer)
    Call DriverDisconnect ' IMPORTANT
    End ' in VB6 this ends this program
End Sub

Private Sub readbutton_Click()
   Dim portnumm%
    'port should be directly readable
    portnumm% = Ddrv.RS232Get(5) 'function 5 is getting current com port number
    portlabel = "driver is on COM:" & portnumm%
    
       If InStr(Ddrv.PumpInfo, "pump") > 0 Then ' Norhof has more devices than pumps
            'YES it is a pump
            infolabel = Ddrv.PumpInfo
            DriverActive = True
            ' for now to keep this simple, make driveractive TRUE when pumpinfo string is filled
            ' later we will make a second check to see if also all slowpolls are received yet
        End If
    
    driveractivelabel = "DriverActive =" & DriverActive
    
End Sub
'========================================================



'========= Demo1 routines


'Start the driver
Private Sub DriverInit()
    
    Set gConn = New Connector
    Set Ddrv = gConn.PumpMonitor
    'driver will search for the correct device(Norhof pump) on port 1-8
    'when found, it will create a "Norport.sys" file in the C:\NorhofLN2pump map to make a second start faster
    'all next starts of the driver will first search for the correct device on this port
    '(if you manualy delete this file, the next start will search all 8 ports again first)
        ' NOTE: in version before, this "Norport.sys" was stored in the C:\Program Files (x86)\NorhofPumpMonitor map
        ' but in Windows 10 this was sometimes not accepted because of user licenses and/or passwords
        ' so since this version 8.62 we create this C:\NorhofLN2pump map and do all writing and reading of files here
    
    'driver connects to the pump, does an init by sending the "i" command to the pump
    'pump will return the info string, in which is the device name and version and date, to the driver
    'and will do directly some init commands by user polls (now 12)
    'Ddrv.PumpInfo can be read to see if the driver is working and if the pump is connected and found
    'after that, the driver start sending poll commands to the pump, and the pump fills many registers in the driver
    '   there are some fastpolls(now 3)   , one every 33 ms
    '   there are some polls    (now 4)   , from which one is send after all 3 fastpolls
    '   there are some slowpols (now 12)  , from which one is send after all 4 polls
    '   more about this later
End Sub

Sub DriverDisconnect()
    ' driver must be unloaded when the last connection closes
    Set Ddrv = Nothing
    Set gConn = Nothing
    DriverActive = False
End Sub
 
 


'===========================================
'===========================================
' END of Demo1 code
'===========================================
'===========================================
'===========================================











